<?php

    /* 
    Plugin Name: MyKeyworder MediaTagger 
    Plugin URI: http://www.mykeyworder.com/mediatagger/
    Description: Auto Tag your Wordpress Media using Artificial Intelligence
    Author: Sam Chadwick 
    Version: 3.0 
    Author URI: http://www.mykeyworder.com 
    */

	// CREATE THE SETTINGS PAGE
	class MyKeyworderMediaTagSettings
	{
		private $options;

		public function __construct()
		{
			add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
			add_action( 'admin_init', array( $this, 'page_init' ) );
		}

		public function add_plugin_page()
		{
			add_options_page(
				'Settings Admin', 
				'MyKeyworder MediaTagger', 
				'manage_options', 
				'mykeyworder-MediaTag-settings-admin', 
				array( $this, 'create_admin_page' )
			);
		}

		public function create_admin_page()
		{
			$this->options = get_option( 'mykeyworder_MediaTag_options' );
			?>
			<div class="wrap">
				<h2>MyKeyworder Media Tagger</h2>           
				<form method="post" action="options.php">
				<?php
					settings_fields( 'mykeyworder_MediaTag_option_group' );   
					do_settings_sections( 'mykeyworder-MediaTag-settings-admin' );
					submit_button(); 
				?>
				</form>
			</div>
			<?php
		}

		public function page_init()
		{        
			register_setting(
				'mykeyworder_MediaTag_option_group',
				'mykeyworder_MediaTag_options',
				array( $this, 'sanitize' )
			);
			
			add_settings_section(
				'welcome_text',
				'How to User this plugin',
				array( $this, 'welcome_text_callback' ),
				'mykeyworder-MediaTag-settings-admin'
			); 

			add_settings_section(
				'api_settings',
				'API Settings',
				array( $this, 'api_settings_callback' ),
				'mykeyworder-MediaTag-settings-admin'
			);   
			
			add_settings_section(
				'tagging_settings',
				'Tagging Settings',
				array( $this ),
				'mykeyworder-MediaTag-settings-admin'
			); 

			add_settings_field(
				'mykeyworder_username',
				'Username',
				array( $this, 'username_callback' ),
				'mykeyworder-MediaTag-settings-admin',
				'api_settings'           
			);   

			add_settings_field(
				'mykeyworder_api_key',
				'API Key',
				array( $this, 'api_key_callback' ),
				'mykeyworder-MediaTag-settings-admin',
				'api_settings'           
			);    

			add_settings_field(
				'mykeyworder_balance',
				'Balance',
				array( $this, 'balance_callback' ),
				'mykeyworder-MediaTag-settings-admin',
				'api_settings'           
			);  


			add_settings_field(
				'mykeyworder_append',
				'Append to Existing Tags',
				array( $this, 'append_callback' ),
				'mykeyworder-MediaTag-settings-admin',
				'tagging_settings'           
			);
			
			add_settings_field(
				'mykeyworder_cust_tax',
				'Custom Taxonomy',
				array( $this, 'cust_tax_callback' ),
				'mykeyworder-MediaTag-settings-admin',
				'tagging_settings'           
			);  
			
		}

		public function sanitize( $input )
		{
			$new_input = array();
			if( isset( $input['mykeyworder_api_key'] ) )
			$new_input['mykeyworder_api_key'] = sanitize_text_field( $input['mykeyworder_api_key'] );

			if( isset( $input['mykeyworder_username'] ) )
			$new_input['mykeyworder_username'] = sanitize_text_field( $input['mykeyworder_username'] );

			if( isset( $input['mykeyworder_append'] ) )
			$new_input['mykeyworder_append'] = $input['mykeyworder_append'];
			
			if( isset( $input['mykeyworder_cust_tax'] ) )
			$new_input['mykeyworder_cust_tax'] = sanitize_text_field( $input['mykeyworder_cust_tax'] );

			return $new_input;
		}

		public function welcome_text_callback()
		{
			$status = file_get_contents('https://www.mykeyworder.com/checkMediaTagplugin/3');

			print 'The MyKeyworder Media Tagger plugin allows you to auto tag images directly from within Wordpress.<br>To use the tool, visit your Media Library.  Then make sure your media is displayed in <b>LIST VIEW</b> and not grid view. <br>Select the images that you would like to tag and then choose "Auto Tag (MyKeyworder)" from the Bulk Actions drop down.<br><br>'.$status;
		}		

		public function api_settings_callback()
		{
			print 'Enter your MyKeyworder API settings.  You can get these at <a href="https://mykeyworder.com/api">https://mykeyworder.com/api</a>';
		}

		public function username_callback()
		{
			printf(
				'<input type="text" id="mykeyworder_username" name="mykeyworder_MediaTag_options[mykeyworder_username]" value="%s" />',
				isset( $this->options['mykeyworder_username'] ) ? esc_attr( $this->options['mykeyworder_username']) : ''
			);
	        	print '<br><small>Enter the Username shown on https://mykeyworder.com/api</small>';
		}

		public function api_key_callback()
		{
			printf(
				'<input type="text" id="mykeyworder_api_key" name="mykeyworder_MediaTag_options[mykeyworder_api_key]" value="%s" />',
				isset( $this->options['mykeyworder_api_key'] ) ? esc_attr( $this->options['mykeyworder_api_key']) : ''
			);
	        	print '<br><small>Enter the API Key shown on https://mykeyworder.com/api</small>';
		}

		public function balance_callback()
		{
			$options = get_option( 'mykeyworder_MediaTag_options' );
			$username = $options['mykeyworder_username'];
			$key = $options['mykeyworder_api_key'];

			if($username == '' || $key == ''){
				print 'Enter your username and api key to retrieve your current balance.  To get your credentials, visit https://mykeyworder.com/api';
			} else {
				$balance = mykeyworder_mediatag_get_balance();
				print 'Your current balance is: '.$balance.' credits.<br><small>To buy more credits, visit https://mykeyworder.com/account</small>';
			}
		}

		public function append_callback()
		{
			$options = get_option( 'mykeyworder_MediaTag_options' );
			printf(
				'<input type="checkbox" id="mykeyworder_append" name="mykeyworder_MediaTag_options[mykeyworder_append]" value="1"'. checked( 1, $options['mykeyworder_append'], false ) . '/>');
			print '<br><small>Check the box to have MyKeyworder append to the existing tags.  Leave the box unchecked to have MyKeyworder replace the existing tags.</small>';
		}
		
		public function cust_tax_callback()
		{
			printf(
				'<input type="text" id="mykeyworder_cust_tax" name="mykeyworder_MediaTag_options[mykeyworder_cust_tax]" value="%s" />',
				isset( $this->options['mykeyworder_cust_tax'] ) ? esc_attr( $this->options['mykeyworder_cust_tax']) : ''
			);
	        	print '<br><small>Visit Media->Tags and look at the URL.  It will look something like this: <i>/wp-admin/edit-tags.php?taxonomy=<b>post_tag</b>&post_type=attachment</i><br>If the value you have for taxonomy is post_tag, like it is in the example, you can leave this box empty.<br>If you see a different value then add it here.  This makes sure that MyKeyworder adds tags to your custom taxonomy structure.</small>';
		}
	}

	// ADD THE FUNCTION TO THE BULK ACTIONS
	add_filter( 'bulk_actions-upload', 'mykeyworder_MediaTag_register_bulk_actions' );
	 
	function mykeyworder_MediaTag_register_bulk_actions($bulk_actions) {
	  $bulk_actions['mykeyworder_mediatag'] = __( 'Auto Tag (MyKeyworder)', 'mykeyworder_mediatag');
	  return $bulk_actions;
	}

	// PERFORM MYKEYWORDER AUTOTAG FOR EACH IMAGE SELECTED
	add_filter( 'handle_bulk_actions-upload', 'mykeyworder_MediaTag_action_handler', 10, 3 );
	 
	function mykeyworder_MediaTag_action_handler( $redirect_to, $doaction, $post_ids ) {
	 	if ( $doaction !== 'mykeyworder_mediatag' ) {
	    	return $redirect_to;
	  	}
			$options = get_option( 'mykeyworder_MediaTag_options' );
			$username = $options['mykeyworder_username'];
			$key = $options['mykeyworder_api_key'];
			$append = $options['mykeyworder_append'];
			$taxonomy = isset($options['mykeyworder_cust_tax']) ? $options['mykeyworder_cust_tax'] : 'post_tag';
		
			foreach ( $post_ids as $post_id ) {
				
				$attachment = wp_get_attachment_image_src( $post_id, 'full' );
				$image_url = $attachment['0'];
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://mykeyworder.com/api/v1/analyze?url='.urlencode($image_url));
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
				curl_setopt($ch, CURLOPT_HEADER, FALSE);
				curl_setopt($ch, CURLOPT_USERPWD, $username.':'.$key);
				$response = curl_exec($ch);
				curl_close($ch);
				$json_response = json_decode($response);
				$tags = $json_response->keywords;
				
				// Now write the tags to the database
				wp_set_post_terms($post_id,$tags,$taxonomy,$append);
			}

		$redirect_to = add_query_arg( 'bulk_tagged_media', count( $post_ids ), $redirect_to );
		return $redirect_to;
	}

	// DISPLAY THE NOTICES ON COMPLETION
	add_action( 'admin_notices', 'mykeyworder_MediaTag_action_admin_notice' );
	 
	function mykeyworder_MediaTag_action_admin_notice() {
	  if ( ! empty( $_REQUEST['bulk_tagged_media'] ) ) {

	  	$tagged_count = intval( $_REQUEST['bulk_tagged_media'] );
	  	$balance = mykeyworder_mediatag_get_balance();

	    printf( '<div id="message" class="updated fade">' .
	      _n( 'Tagged %s images.',
	        'Tagged %s images.',
	        $tagged_count,
	        'mykeyworder_mediatag'
	      ) . '</div>', $tagged_count );
	    printf( '<div id="balance" class="updated fade">' .
	      _n( 'You have %s credits remaining. To buy more credits, visit https://mykeyworder.com/account',
	        'You have %s credits remaining. To buy more credits, visit https://mykeyworder.com/account',
	        $balance,
	        'mykeyworder_mediatag'
	      ) . '</div>', $balance );
	  }
	}

	function mykeyworder_mediatag_get_balance(){

		$options = get_option( 'mykeyworder_MediaTag_options' );
		$username = $options['mykeyworder_username'];
		$key = $options['mykeyworder_api_key'];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://mykeyworder.com/api/v1/balance');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);
		curl_setopt($ch, CURLOPT_USERPWD, $username.':'.$key);
		$response = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($response);
		if(isset($response->error)){
			return $response->error;
		} else {
			return $response;
		}
	}

	// Add a new column
	add_filter('manage_media_columns', 'add_topic_column');
	function add_topic_column($posts_columns) {
		$options = get_option( 'mykeyworder_MediaTag_options' );
		$taxonomy = isset($options['mykeyworder_cust_tax']) ? $options['mykeyworder_cust_tax'] : 'post_tag';
		$posts_columns[$taxonomy] = _x('Tags', 'column name');
		return $posts_columns;
	}

	add_action('manage_media_custom_column', 'manage_attachment_topic_column', 10, 2);
	function manage_attachment_topic_column($column_name, $id) {
		$options = get_option( 'mykeyworder_MediaTag_options' );
		$taxonomy = isset($options['mykeyworder_cust_tax']) ? $options['mykeyworder_cust_tax'] : 'post_tag';
		switch($column_name) {
		case $taxonomy:
			$tags = wp_get_object_terms( $id, $taxonomy, '' );
			if ( !empty( $tags ) ) {
				$out = array();
				foreach ( $tags as $c )
					$out[] = esc_html(sanitize_term_field('name'
							 , $c->name, $c->term_id, 'post_tag', 'display'));
				echo join( ', ', $out );
			} else {
				_e('No Tags');
			}
			break;
		default:
			break;
		}
	}

    $mykeyworder_MediaTag_settings_page = new MyKeyworderMediaTagSettings();
?>